//*******************************************************************************************************************************************
// The methods of this class display information about the sentence corpus and statistics related to the model's performance.
//*******************************************************************************************************************************************

package ezreader10;

import java.io.PrintStream;
import java.util.*;

class Display {
    
    //**************************************************************************
    
    void corpus(PrintStream diskWriter, ArrayList<Sentence> text) {
        
        for (int i = 0; i < EZReader10.NSentences; i++) {
            diskWriter.printf(" Sentence %2d\n", i);
            for (int j = 0; j < text.get(i).numberWords; j++) {             
                diskWriter.printf(" %9.0f %4.2f %2.0f %3.0f %4.1f %3.0f" + 
                        text.get(i).get(j).iv.letters, 
                        text.get(i).get(j).iv.frequency, 
                        text.get(i).get(j).iv.cloze,
                        text.get(i).get(j).iv.length, 
                        text.get(i).get(j).iv.position0, 
                        text.get(i).get(j).iv.OVP, 
                        text.get(i).get(j).iv.positionN);
                if (j == text.get(i).target) diskWriter.printf(" *"); // target
                diskWriter.println();
            }
        }
    }
    
    //**************************************************************************
     
    void distPr1(PrintStream diskWriter, ArrayList<Sentence> text) {   
        
        diskWriter.println();
        diskWriter.printf(" Pr1 distributions (i.e., first-fixation landing sites):\n");
        for (int i = 0; i < EZReader10.NSentences; i++) {
            for (int j = 1; j < text.get(i).numberWords - 1; j++) {   
                for (int k = 0; k <= text.get(i).get(j).iv.length; k++) diskWriter.printf(" %3.2f", text.get(i).get(j).dv.distPr1[k]);
                diskWriter.printf(" " + text.get(i).get(j).iv.letters);
                if (EZReader10.includeTargetWords == true && j == text.get(i).target) diskWriter.printf(" *"); // i.e., tag target words
                diskWriter.println();
            }
        }
    }
 
    //**************************************************************************
    
    void distPr2(PrintStream diskWriter, ArrayList<Sentence> text) { 
        
        diskWriter.println();
        diskWriter.printf(" Pr2 distributions (i.e., refixation probabilities):\n");
        for (int i = 0; i < EZReader10.NSentences; i++) {
            for (int j = 1; j < text.get(i).numberWords - 1; j++) {
                for (int k = 0; k <= text.get(i).get(j).iv.length; k++) diskWriter.printf(" %3.2f", text.get(i).get(j).dv.distPr2[k]);
                diskWriter.printf(" " + text.get(i).get(j).iv.letters);
                if (EZReader10.includeTargetWords == true && j == text.get(i).target) diskWriter.printf(" *"); // i.e., tag target words
                diskWriter.println();
            }
        }
    }

    //**************************************************************************
    
    void distSFD(PrintStream diskWriter, ArrayList<Sentence> text) { 
        
        diskWriter.println();
        diskWriter.printf(" SFD distributions (i.e., inverted optimal viewing position effects):\n");
        for (int i = 0; i < EZReader10.NSentences; i++) {
            for (int j = 1; j < text.get(i).numberWords - 1; j++) {
                for (int k = 0; k <= text.get(i).get(j).iv.length; k++) diskWriter.printf(" %4.0f", text.get(i).get(j).dv.distSFD[k]);
                diskWriter.printf(" " + text.get(i).get(j).iv.letters);
                if (EZReader10.includeTargetWords == true && j == text.get(i).target) diskWriter.printf(" *"); // i.e., tag target words
                diskWriter.println();
            }
        }
    }

    //**************************************************************************
    
    void frequencyClassMeans(PrintStream diskWriter, ArrayList<Word> classMeans) {

        diskWriter.printf(" f    SFD      FFD       GD       Pr1        Pr2        PrS\n");
        diskWriter.printf(" -  -------  -------  -------  ---------  ---------  ---------\n");
        for (int i = 0; i < EZReader10.NFrequencyClasses; i++) {
            diskWriter.printf(" %1d  %3.0f %3.0f  %3.0f %3.0f  %3.0f %3.0f  %4.2f %4.2f  %4.2f %4.2f  %4.2f %4.2f\n", i + 1,                     
                    EZReader10.obsMeanSFD[i], classMeans.get(i).dv.SFD, 
                    EZReader10.obsMeanFFD[i], classMeans.get(i).dv.FFD, 
                    EZReader10.obsMeanGD[i], classMeans.get(i).dv.GD,
                    EZReader10.obsMeanPr1[i], classMeans.get(i).dv.Pr1, 
                    EZReader10.obsMeanPr2[i], classMeans.get(i).dv.Pr2, 
                    EZReader10.obsMeanPrS[i], classMeans.get(i).dv.PrS);
        }
        diskWriter.println();
    }
    
    //**************************************************************************
     
    void meanDistPr1(PrintStream diskWriter, ArrayList<Word> fixDists) {
        
        diskWriter.println();
        diskWriter.printf(" Pr1 distributions (i.e., first-fixation landing sites):\n");
        for (int i = 1; i < EZReader10.maxLength; i++) {
            diskWriter.printf(" %2d-letter: ", i);
            for (int j = 0; j <= i; j++) diskWriter.printf(" %4.2f", fixDists.get(i).dv.distPr1[j]);
            diskWriter.println();
        }
        diskWriter.println();
    }
    
    //**************************************************************************
    
    void meanDistPr2(PrintStream diskWriter, ArrayList<Word> fixDists) {
            
        diskWriter.println();
        diskWriter.printf(" Pr2 distributions (i.e., refixation probabilities):\n");
        for (int i = 1; i < EZReader10.maxLength; i++) {
            diskWriter.printf(" %2d-letter: ", i);
            for (int j = 0; j <= i; j++) diskWriter.printf(" %4.2f", fixDists.get(i).dv.distPr2[j]);
            diskWriter.println();
        }
        diskWriter.println();
    }

    //**************************************************************************
    
    void meanDistSFD(PrintStream diskWriter, ArrayList<Word> IOVPs) {
        
        diskWriter.println();
        diskWriter.printf(" SFD distributions (i.e., inverted optimal viewing position effects):\n");
        for (int i = 1; i < EZReader10.maxLength; i++) {
            diskWriter.printf(" %2d-letter: ", i);
            for (int j = 0; j <= i; j++) diskWriter.printf(" %4.0f", IOVPs.get(i).dv.distSFD[j]);
            diskWriter.println();
        }
        diskWriter.println();
    }
    
    //**************************************************************************
    
    void parameters(PrintStream diskWriter) {
        
        diskWriter.printf("\n Parameter values:\n");
        diskWriter.printf(" A = %3.2f\n", EZReader10.A);
        diskWriter.printf(" Alpha1 = %3.2f\n", EZReader10.Alpha1);
        diskWriter.printf(" Alpha2 = %3.2f\n", EZReader10.Alpha2);
        diskWriter.printf(" Alpha3 = %3.2f\n", EZReader10.Alpha3);
        diskWriter.printf(" Delta = %3.2f\n", EZReader10.Delta);
        diskWriter.printf(" Epsilon1 = %3.2f\n", EZReader10.Epsilon1);
        diskWriter.printf(" Epsilon2 = %3.2f\n", EZReader10.Epsilon2);
        diskWriter.printf(" Epsilon3 = %3.2f\n", EZReader10.Epsilon3);
        diskWriter.printf(" Eta1 = %3.2f\n", EZReader10.Eta1);
        diskWriter.printf(" Eta2 = %3.2f\n", EZReader10.Eta2);
        diskWriter.printf(" I = %3.2f\n", EZReader10.I);
        diskWriter.printf(" ITarget = %3.2f\n", EZReader10.ITarget);
        diskWriter.printf(" Lambda = %3.2f\n", EZReader10.Lambda);
        diskWriter.printf(" M1 = %3.2f\n", EZReader10.M1);
        diskWriter.printf(" M2 = %3.2f\n", EZReader10.M2);
        diskWriter.printf(" Omega1 = %3.2f\n", EZReader10.Omega1);
        diskWriter.printf(" Omega2 = %3.2f\n", EZReader10.Omega2);
        diskWriter.printf(" pF = %3.2f\n", EZReader10.pF);
        diskWriter.printf(" pFTarget = %3.2f\n", EZReader10.pFTarget);
        diskWriter.printf(" Psi = %3.2f\n", EZReader10.Psi);
        diskWriter.printf(" S = %3.2f\n", EZReader10.S);
        diskWriter.printf(" SigmaGamma = %3.2f\n", EZReader10.SigmaGamma);
        diskWriter.printf(" V = %3.2f\n", EZReader10.V);
        diskWriter.printf(" Xi = %3.2f\n\n", EZReader10.Xi);
        diskWriter.printf(" NSubjects = %1d\n", EZReader10.NSubjects);
        diskWriter.println(" Include regression trials? " + EZReader10.includeRegressionTrials);
        diskWriter.println(" Include target words? " + EZReader10.includeTargetWords);
        diskWriter.printf(" --------------------------------------\n\n");
    }
    
    //**************************************************************************
     
    void PrRegression(PrintStream diskWriter, double regressions) {
        
        diskWriter.printf(" PrRegressions %5.4f\n", regressions);
    }

    //**************************************************************************
     
    void RMSD(PrintStream diskWriter, double RMSD) {
        
        diskWriter.printf(" RMSD %5.4f\n", RMSD);
    }

    //**************************************************************************
     
    void states(PrintStream diskWriter, int sentence, int N, Fixation f, 
            double processingRate, ArrayList<Process> active, boolean[] IFailed, ArrayList<Sentence> text, String state) {
        
        diskWriter.printf(" S %2d", sentence); // sentence number
        diskWriter.printf(" N %2d", N); // word number being attended
        diskWriter.printf(" fix# %2d", f.number); // fixation number
        diskWriter.printf(" word %2d", f.word); // word number being fixated
        diskWriter.printf(" pos %4.1f", f.position); // fixation position
        diskWriter.printf(" dur %4.0f", f.duration); // fixation duration
        diskWriter.printf(" rate %4.2f", processingRate); // processing rate
        diskWriter.printf(" - " + state); // model state (i.e., process that just completed)
        
        // Identify & display all active processes:
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("V"))
            diskWriter.printf(" V %1.0f [%d]", active.get(i).duration, active.get(i).word);
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("L1")) 
            diskWriter.printf(" L1 %1.0f [%d]", active.get(i).duration, active.get(i).word);
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("L2")) 
            diskWriter.printf(" L2 %1.0f [%d]", active.get(i).duration, active.get(i).word);
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("I")) 
            diskWriter.printf(" I %1.0f [%d]", active.get(i).duration, active.get(i).word);
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("A")) 
            diskWriter.printf(" A %1.0f [%d]", active.get(i).duration, active.get(i).word);
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("M1")) 
            diskWriter.printf(" M1 %1.0f [%1d %2.1f]", active.get(i).duration, active.get(i).word, active.get(i).length);
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("M2")) 
            diskWriter.printf(" M2 %1.0f [%2.1f]", active.get(i).duration, active.get(i).length);
        for (int i = 0; i < active.size(); i++) if (active.get(i).name.equals("S")) 
            diskWriter.printf(" S %1.0f", active.get(i).duration);
        diskWriter.printf(" IF:");
        for (int i = 0; i < text.get(sentence).numberWords; i++) if (IFailed[i] == true) diskWriter.printf(" %d", i);
        diskWriter.println();
    }

    //**************************************************************************
     
    void traces(PrintStream diskWriter, ArrayList<Sentence> text, int S, ArrayList<Fixation> trace) {
        
        for (int i = 0; i < trace.size(); i++) {
            diskWriter.printf(" fix: %2d dur: %3.0f pos: %4.1f word: %2d ", i, trace.get(i).duration, 
                    trace.get(i).position, trace.get(i).word);
            diskWriter.printf(text.get(S).get(trace.get(i).word).iv.letters);
            diskWriter.println();
        }
    }
    
    //**************************************************************************
     
    void wordMeans(PrintStream diskWriter, ArrayList<Sentence> text) {
            
        diskWriter.println();
        diskWriter.printf(" Word-based means:\n");
        for (int i = 0; i < EZReader10.NSentences; i++) {       
            for (int j = 1; j < text.get(i).numberWords - 1; j++) {
                diskWriter.printf(" SFD %3.0f ", text.get(i).get(j).dv.SFD);
                diskWriter.printf(" FFD %3.0f ", text.get(i).get(j).dv.FFD);
                diskWriter.printf(" GD %3.0f ", text.get(i).get(j).dv.GD);
                diskWriter.printf(" TT %3.0f ", text.get(i).get(j).dv.TT);
                diskWriter.printf(" GP %3.0f ", text.get(i).get(j).dv.GoPast);
                diskWriter.printf(" PrF %3.2f", text.get(i).get(j).dv.PrF);
                diskWriter.printf(" Pr1 %3.2f", text.get(i).get(j).dv.Pr1);
                diskWriter.printf(" Pr2 %3.2f", text.get(i).get(j).dv.Pr2);
                diskWriter.printf(" PrS %3.2f" + text.get(i).get(j).iv.letters, text.get(i).get(j).dv.PrS);
                if (EZReader10.includeTargetWords == true && j == text.get(i).target) diskWriter.printf(" *"); // target
                diskWriter.println();
            }
        }  
    }
}

//*******************************************************************************************************************************************


